/**
\file
\brief 	This file controls the TPM module, configured as PWM edge aligned to dim the High Brightness LEDs
\author Samuel Quiroz
\date 2009-04-03
*/

#ifndef _TPM_PWM1
#define _TPM_PWM1


#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */
#include "SystemConfig.h"
#include "PublicTypes.h"


/** PWM frequency in Hz */
#define PWM_FREQ		((UINT32)(20000))		//Hz

//#define TPM1_OVF_PERIOD_us			50			//us

/** TPM Preescaler in decimal format */
#define TPM1_PRESCALER   		(1)			//preescaler of 1

/** TPM Preescaler in binary format according to GB60 datasheet:
 	Check this table to select proper value, it must match the TPM2_PRESCALER value
	0:0:0 	1
	0:0:1 	2
	0:1:0 	4
	0:1:1 	8
	1:0:0 	16
	1:0:1 	32
	1:1:0 	64
	1:1:1 	128
*/
#define TPM1_PRESCALER_VALUE	(0b000)		//preescaler of 1


#define TPM1_TICK_FREQ       ((UINT32)(BUS_FREQ/TPM1_PRESCALER)) 	//

//#define TPM1C3SC_VALUE	(TPM1C3SC_MS1B_MASK|TPM2C1SC_ELS1B_MASK)
//#define TPM1C2SC_VALUE	(TPM2C2SC_MS2B_MASK|TPM2C2SC_ELS2B_MASK)
#define TPM1C3SC_VALUE	(TPM1C3SC_MS3B_MASK|TPM1C3SC_ELS3B_MASK)
//#define TPM1C4SC_VALUE	(TPM2C4SC_MS4B_MASK|TPM2C4SC_ELS4B_MASK)
//#define TPM1C5SC_VALUE	(TPM1C5SC_MS5B_MASK|TPM1C5SC_ELS5B_MASK)

#define TPM1_SC_VALUE	((UINT8)(TPM1_PRESCALER_VALUE)/*|TPM1SC_TOIE_MASK*/)
#define TPM1_MOD_VALUE	((UINT16)(TPM1_TICK_FREQ/PWM_FREQ))



#define TMP1_CLEAR_OV_FLAG()		TPM1SC_TOF = 0x00

#define TPM_MAX_VAL			(UINT32)(TPM1_TICK_FREQ/PWM_FREQ)


#define TPM1C3_PIN_DD	PTDDD_PTDDD5
#define TPM1C3_PIN_D	PTDD_PTDD5

#define TPM1_START()		TPM1SC_CLKSx = 0x1
#define TPM1_STOP()			TPM1SC_CLKSx = 0x0
			
void Pwm1_Init(void);
void Pwm1_Stop(void);
void Pwm1_Start(UINT16 dutyCycle);





#endif //_TPM_PWM1